# common functions to generate uniform reports
knitr::opts_chunk$set(echo = TRUE, width = 110)

library(flextable)
library(officer)
library('ReporteRs')

require("modelr")
require("tidyverse")
require("tidybayes")
require("openxlsx")
require("ggstance")
require("ggridges")
require("cowplot")
require("rstan")
require("brms")
require("emmeans")

# rstan_options(auto_write = TRUE)
my.cores <- min(4,parallel::detectCores()-1) #DEBUG# leave one free core to keep system responsive
# my.cores <- min(4,parallel::detectCores()) #NormalRun# we always use chains == cores to avoid >2x slowdown
options(mc.cores = my.cores)
theme_set(theme_light())
S_width <- 13.33/2.0
S_height <- 7.5/2
plt <- list()

# add stars to p.values
signif.num <- function(x) {
  as.character(symnum(x, corr = FALSE, na = FALSE, legend = FALSE,
                      cutpoints = c(0, 0.001, 0.01, 0.05, 0.1, 1), 
                      symbols = c("***", "**", "*", ".", " ")))
}

# color significan emm summary in light green
emm_show <- function(myemm, myDraws = NULL) {
  set.seed(1) # reproducible mvt-adjustment for P-value
  myft <- summary(myemm, infer=TRUE, frequentist=TRUE, adjust="mvt") %>% as_tibble
  myft <- myft %>% select(one_of(setdiff( 
    names(myft), c("emmean", "response", "estimate", "prob", "SE", "df", "asymp.LCL", "asymp.UCL", "z.ratio")
  ))) # leave only p.value column

  if(is.null(myDraws)) {
    myft.median_hdi <- summary(myemm)
    myft <- merge(myft.median_hdi, myft, sort=FALSE, all=TRUE)  
  } else {
    myft.median_hdi <- myDraws %>% 
      median_hdci() %>% 
      ungroup() %>%
      select(
        one_of(setdiff(names(myft), c("p.value"))),
        .value, .lower, .upper) %>% 
      rename(median=.value, lower.HPD=.lower, upper.HPD=.upper)
    myft <- merge(myft.median_hdi, myft, sort=FALSE, all.x=TRUE, all.y=FALSE)  
  }
  
  myft <- flextable(myft)
  myft <- bold(myft, i = ~ lower.HPD*upper.HPD > 0, bold = TRUE)
  myft <- bg(myft, i = ~ p.value >= 0.05 & lower.HPD*upper.HPD > 0, j = ~ p.value, bg="yellow")
  myft <- fontsize(myft, part = "all", size = 10)
  myft <- set_formatter(myft, p.value = function(x) sprintf("%.2e", x) )
  autofit(myft)
}

emm_inorder <- function(myemm) {
  # yield draws, restoring correct order of groups (work around a bug of R/tidybayes)
  gather_emmeans_draws(myemm) %>% ungroup %>% mutate_if(is.character, fct_inorder)
}

my.stat_eyeh <- function(ggp, ...) {
  ggp +
    stat_halfeyeh(point_interval = median_hdci, .width = 0.95,
             shape = 16, point_color = "black", interval_color = "black",
             slab_color = NA, normalize="groups", ... ) +
    scale_fill_brewer(palette = "Set2") + 
    scale_color_brewer(palette = "Dark2")
}

my.legend <- function(...) {theme(
  legend.title = element_text(size=12, color = "salmon", face="bold"),
  # legend.justification=c(0,1), legend.position=c(0.05, 0.95),
  legend.background = element_blank(),
  legend.key = element_blank(), ...)}
  

